/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.scheduler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_12_R1.scheduler.CraftAsyncScheduler;
import org.bukkit.craftbukkit.v1_12_R1.scheduler.CraftAsyncTask;
import org.bukkit.craftbukkit.v1_12_R1.scheduler.CraftFuture;
import org.bukkit.craftbukkit.v1_12_R1.scheduler.CraftTask;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;

public class CraftScheduler
implements BukkitScheduler {
    private final AtomicInteger ids = new AtomicInteger(1);
    private volatile CraftTask head = new CraftTask();
    private final AtomicReference<CraftTask> tail = new AtomicReference<CraftTask>(this.head);
    final PriorityQueue<CraftTask> pending = new PriorityQueue<CraftTask>(10, new Comparator<CraftTask>(){

        @Override
        public int compare(CraftTask o1, CraftTask o2) {
            int value = Long.compare(o1.getNextRun(), o2.getNextRun());
            return value != 0 ? value : Integer.compare(o1.getTaskId(), o2.getTaskId());
        }
    });
    private final List<CraftTask> temp = new ArrayList<CraftTask>();
    final ConcurrentHashMap<Integer, CraftTask> runners = new ConcurrentHashMap();
    private volatile CraftTask currentTask = null;
    volatile int currentTick = -1;
    private static final int RECENT_TICKS = 30;
    private final CraftScheduler asyncScheduler;
    private final boolean isAsyncScheduler;

    public CraftScheduler() {
        this(false);
    }

    public CraftScheduler(boolean isAsync) {
        this.isAsyncScheduler = isAsync;
        this.asyncScheduler = isAsync ? this : new CraftAsyncScheduler();
    }

    @Override
    public int scheduleSyncDelayedTask(Plugin plugin, Runnable task) {
        return this.scheduleSyncDelayedTask(plugin, task, 0L);
    }

    @Override
    public BukkitTask runTask(Plugin plugin, Runnable runnable) {
        return this.runTaskLater(plugin, runnable, 0L);
    }

    @Override
    @Deprecated
    public int scheduleAsyncDelayedTask(Plugin plugin, Runnable task) {
        return this.scheduleAsyncDelayedTask(plugin, task, 0L);
    }

    @Override
    public BukkitTask runTaskAsynchronously(Plugin plugin, Runnable runnable) {
        return this.runTaskLaterAsynchronously(plugin, runnable, 0L);
    }

    @Override
    public int scheduleSyncDelayedTask(Plugin plugin, Runnable task, long delay) {
        return this.scheduleSyncRepeatingTask(plugin, task, delay, -1L);
    }

    @Override
    public BukkitTask runTaskLater(Plugin plugin, Runnable runnable, long delay) {
        return this.runTaskTimer(plugin, runnable, delay, -1L);
    }

    @Override
    @Deprecated
    public int scheduleAsyncDelayedTask(Plugin plugin, Runnable task, long delay) {
        return this.scheduleAsyncRepeatingTask(plugin, task, delay, -1L);
    }

    @Override
    public BukkitTask runTaskLaterAsynchronously(Plugin plugin, Runnable runnable, long delay) {
        return this.runTaskTimerAsynchronously(plugin, runnable, delay, -1L);
    }

    @Override
    public int scheduleSyncRepeatingTask(Plugin plugin, Runnable runnable, long delay, long period) {
        return this.runTaskTimer(plugin, runnable, delay, period).getTaskId();
    }

    @Override
    public BukkitTask runTaskTimer(Plugin plugin, Runnable runnable, long delay, long period) {
        CraftScheduler.validate(plugin, runnable);
        if (delay < 0L) {
            delay = 0L;
        }
        if (period == 0L) {
            period = 1L;
        } else if (period < -1L) {
            period = -1L;
        }
        return this.handle(new CraftTask(plugin, runnable, this.nextId(), period), delay);
    }

    @Override
    @Deprecated
    public int scheduleAsyncRepeatingTask(Plugin plugin, Runnable runnable, long delay, long period) {
        return this.runTaskTimerAsynchronously(plugin, runnable, delay, period).getTaskId();
    }

    @Override
    public BukkitTask runTaskTimerAsynchronously(Plugin plugin, Runnable runnable, long delay, long period) {
        CraftScheduler.validate(plugin, runnable);
        if (delay < 0L) {
            delay = 0L;
        }
        if (period == 0L) {
            period = 1L;
        } else if (period < -1L) {
            period = -1L;
        }
        return this.handle(new CraftAsyncTask(this.asyncScheduler.runners, plugin, runnable, this.nextId(), period), delay);
    }

    @Override
    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task) {
        CraftScheduler.validate(plugin, task);
        CraftFuture<T> future = new CraftFuture<T>(task, plugin, this.nextId());
        this.handle(future, 0L);
        return future;
    }

    @Override
    public void cancelTask(final int taskId) {
        CraftTask task;
        if (taskId <= 0) {
            return;
        }
        if (!this.isAsyncScheduler) {
            this.asyncScheduler.cancelTask(taskId);
        }
        if ((task = this.runners.get(taskId)) != null) {
            task.cancel0();
        }
        task = new CraftTask(new Runnable(){

            @Override
            public void run() {
                if (!this.check(CraftScheduler.this.temp)) {
                    this.check(CraftScheduler.this.pending);
                }
            }

            private boolean check(Iterable<CraftTask> collection) {
                Iterator<CraftTask> tasks = collection.iterator();
                while (tasks.hasNext()) {
                    CraftTask task = tasks.next();
                    if (task.getTaskId() != taskId) continue;
                    task.cancel0();
                    tasks.remove();
                    if (task.isSync()) {
                        CraftScheduler.this.runners.remove(taskId);
                    }
                    return true;
                }
                return false;
            }
        });
        this.handle(task, 0L);
        for (CraftTask taskPending = this.head.getNext(); taskPending != null; taskPending = taskPending.getNext()) {
            if (taskPending == task) {
                return;
            }
            if (taskPending.getTaskId() != taskId) continue;
            taskPending.cancel0();
        }
    }

    @Override
    public void cancelTasks(final Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Cannot cancel tasks of null plugin");
        if (!this.isAsyncScheduler) {
            this.asyncScheduler.cancelTasks(plugin);
        }
        CraftTask task = new CraftTask(new Runnable(){

            @Override
            public void run() {
                this.check(CraftScheduler.this.pending);
                this.check(CraftScheduler.this.temp);
            }

            void check(Iterable<CraftTask> collection) {
                Iterator<CraftTask> tasks = collection.iterator();
                while (tasks.hasNext()) {
                    CraftTask task = tasks.next();
                    if (!task.getOwner().equals(plugin)) continue;
                    task.cancel0();
                    tasks.remove();
                    if (!task.isSync()) continue;
                    CraftScheduler.this.runners.remove(task.getTaskId());
                }
            }
        });
        this.handle(task, 0L);
        for (CraftTask taskPending = this.head.getNext(); taskPending != null && taskPending != task; taskPending = taskPending.getNext()) {
            if (taskPending.getTaskId() == -1 || !taskPending.getOwner().equals(plugin)) continue;
            taskPending.cancel0();
        }
        for (CraftTask runner : this.runners.values()) {
            if (!runner.getOwner().equals(plugin)) continue;
            runner.cancel0();
        }
    }

    @Override
    public void cancelAllTasks() {
        if (!this.isAsyncScheduler) {
            this.asyncScheduler.cancelAllTasks();
        }
        CraftTask task = new CraftTask(new Runnable(){

            @Override
            public void run() {
                Iterator<CraftTask> it = CraftScheduler.this.runners.values().iterator();
                while (it.hasNext()) {
                    CraftTask task = it.next();
                    task.cancel0();
                    if (!task.isSync()) continue;
                    it.remove();
                }
                CraftScheduler.this.pending.clear();
                CraftScheduler.this.temp.clear();
            }
        });
        this.handle(task, 0L);
        for (CraftTask taskPending = this.head.getNext(); taskPending != null && taskPending != task; taskPending = taskPending.getNext()) {
            taskPending.cancel0();
        }
        for (CraftTask runner : this.runners.values()) {
            runner.cancel0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrentlyRunning(int taskId) {
        if (!this.isAsyncScheduler && this.asyncScheduler.isCurrentlyRunning(taskId)) {
            return true;
        }
        CraftTask task = this.runners.get(taskId);
        if (task == null) {
            return false;
        }
        if (task.isSync()) {
            return task == this.currentTask;
        }
        CraftAsyncTask asyncTask = (CraftAsyncTask)task;
        LinkedList<BukkitWorker> linkedList = asyncTask.getWorkers();
        synchronized (linkedList) {
            return !asyncTask.getWorkers().isEmpty();
        }
    }

    @Override
    public boolean isQueued(int taskId) {
        CraftTask task;
        if (taskId <= 0) {
            return false;
        }
        if (!this.isAsyncScheduler && this.asyncScheduler.isQueued(taskId)) {
            return true;
        }
        for (task = this.head.getNext(); task != null; task = task.getNext()) {
            if (task.getTaskId() != taskId) continue;
            return task.getPeriod() >= -1L;
        }
        task = this.runners.get(taskId);
        return task != null && task.getPeriod() >= -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BukkitWorker> getActiveWorkers() {
        if (!this.isAsyncScheduler) {
            return this.asyncScheduler.getActiveWorkers();
        }
        ArrayList<BukkitWorker> workers = new ArrayList<BukkitWorker>();
        for (CraftTask taskObj : this.runners.values()) {
            if (taskObj.isSync()) continue;
            CraftAsyncTask task = (CraftAsyncTask)taskObj;
            LinkedList<BukkitWorker> linkedList = task.getWorkers();
            synchronized (linkedList) {
                workers.addAll(task.getWorkers());
            }
        }
        return workers;
    }

    @Override
    public List<BukkitTask> getPendingTasks() {
        ArrayList<CraftTask> truePending = new ArrayList<CraftTask>();
        for (CraftTask task = this.head.getNext(); task != null; task = task.getNext()) {
            if (task.getTaskId() == -1) continue;
            truePending.add(task);
        }
        ArrayList<BukkitTask> pending = new ArrayList<BukkitTask>();
        for (CraftTask task : this.runners.values()) {
            if (task.getPeriod() < -1L) continue;
            pending.add(task);
        }
        for (CraftTask task : truePending) {
            if (task.getPeriod() < -1L || pending.contains(task)) continue;
            pending.add(task);
        }
        if (!this.isAsyncScheduler) {
            pending.addAll(this.asyncScheduler.getPendingTasks());
        }
        return pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainThreadHeartbeat(int currentTick) {
        if (!this.isAsyncScheduler) {
            this.asyncScheduler.mainThreadHeartbeat(currentTick);
        }
        this.currentTick = currentTick;
        List<CraftTask> temp = this.temp;
        this.parsePending();
        while (this.isReady(currentTick)) {
            CraftTask task = (CraftTask)this.pending.remove();
            if (task.getPeriod() < -1L) {
                if (task.isSync()) {
                    this.runners.remove(task.getTaskId(), task);
                }
                this.parsePending();
                continue;
            }
            if (task.isSync()) {
                this.currentTask = task;
                try {
                    task.timings.startTiming();
                    task.run();
                    task.timings.stopTiming();
                }
                catch (Throwable throwable) {
                    task.getOwner().getLogger().log(Level.WARNING, String.format("Task #%s for %s generated an exception", task.getTaskId(), task.getOwner().getDescription().getFullName()), throwable);
                }
                finally {
                    this.currentTask = null;
                }
                this.parsePending();
            } else {
                task.getOwner().getLogger().log(Level.SEVERE, "Unexpected Async Task in the Sync Scheduler. Report this to CatServer");
            }
            long period = task.getPeriod();
            if (period > 0L) {
                task.setNextRun((long)currentTick + period);
                temp.add(task);
                continue;
            }
            if (!task.isSync()) continue;
            this.runners.remove(task.getTaskId());
        }
        this.pending.addAll(temp);
        temp.clear();
    }

    protected void addTask(CraftTask task) {
        AtomicReference<CraftTask> tail = this.tail;
        CraftTask tailTask = tail.get();
        while (!tail.compareAndSet(tailTask, task)) {
            tailTask = tail.get();
        }
        tailTask.setNext(task);
    }

    protected CraftTask handle(CraftTask task, long delay) {
        if (!this.isAsyncScheduler && !task.isSync()) {
            this.asyncScheduler.handle(task, delay);
            return task;
        }
        task.setNextRun((long)this.currentTick + delay);
        this.addTask(task);
        return task;
    }

    private static void validate(Plugin plugin, Object task) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        Validate.notNull((Object)task, (String)"Task cannot be null");
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register task while disabled");
        }
    }

    private int nextId() {
        return this.ids.incrementAndGet();
    }

    void parsePending() {
        CraftTask head = this.head;
        CraftTask task = head.getNext();
        CraftTask lastTask = head;
        while (task != null) {
            if (task.getTaskId() == -1) {
                task.run();
            } else if (task.getPeriod() >= -1L) {
                this.pending.add(task);
                this.runners.put(task.getTaskId(), task);
            }
            lastTask = task;
            task = lastTask.getNext();
        }
        task = head;
        while (task != lastTask) {
            head = task.getNext();
            task.setNext(null);
            task = head;
        }
        this.head = lastTask;
    }

    private boolean isReady(int currentTick) {
        return !this.pending.isEmpty() && this.pending.peek().getNextRun() <= (long)currentTick;
    }

    public String toString() {
        return "";
    }

    @Override
    @Deprecated
    public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable task, long delay) {
        return this.scheduleSyncDelayedTask(plugin, (Runnable)task, delay);
    }

    @Override
    @Deprecated
    public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable task) {
        return this.scheduleSyncDelayedTask(plugin, (Runnable)task);
    }

    @Override
    @Deprecated
    public int scheduleSyncRepeatingTask(Plugin plugin, BukkitRunnable task, long delay, long period) {
        return this.scheduleSyncRepeatingTask(plugin, (Runnable)task, delay, period);
    }

    @Override
    @Deprecated
    public BukkitTask runTask(Plugin plugin, BukkitRunnable task) throws IllegalArgumentException {
        return this.runTask(plugin, (Runnable)task);
    }

    @Override
    @Deprecated
    public BukkitTask runTaskAsynchronously(Plugin plugin, BukkitRunnable task) throws IllegalArgumentException {
        return this.runTaskAsynchronously(plugin, (Runnable)task);
    }

    @Override
    @Deprecated
    public BukkitTask runTaskLater(Plugin plugin, BukkitRunnable task, long delay) throws IllegalArgumentException {
        return this.runTaskLater(plugin, (Runnable)task, delay);
    }

    @Override
    @Deprecated
    public BukkitTask runTaskLaterAsynchronously(Plugin plugin, BukkitRunnable task, long delay) throws IllegalArgumentException {
        return this.runTaskLaterAsynchronously(plugin, (Runnable)task, delay);
    }

    @Override
    @Deprecated
    public BukkitTask runTaskTimer(Plugin plugin, BukkitRunnable task, long delay, long period) throws IllegalArgumentException {
        return this.runTaskTimer(plugin, (Runnable)task, delay, period);
    }

    @Override
    @Deprecated
    public BukkitTask runTaskTimerAsynchronously(Plugin plugin, BukkitRunnable task, long delay, long period) throws IllegalArgumentException {
        return this.runTaskTimerAsynchronously(plugin, (Runnable)task, delay, period);
    }
}

